/*
 * Decompiled with CFR 0.152.
 */
package scdSchemaCheck.jujutong.scd;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.util.XMLErrorHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class validate {
    private static String xsdUrl = "";
    private static String scdXml = "";
    private static String savePath = "";
    static SAXReader saxReader = new SAXReader();
    static Document document = null;

    public static void main(String[] args) {
        String opttype = "";
        if (args.length == 0) {
            System.out.println("ValidOverWithError:\u65e0\u6548\u7684\u8c03\u7528\u53c2\u6570");
            return;
        }
        opttype = args[0];
        if (!(opttype.equals("1") || opttype.equals("2") || opttype.equals("3"))) {
            System.out.println("ValidOverWithError:\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b\u53c2\u6570");
            return;
        }
        if (opttype.equals("2")) {
            scdXml = args[1];
            if (args.length >= 3) {
                savePath = args[2];
            }
            if (scdXml.equals("")) {
                System.out.println("ValidOverWithError:\u672a\u6307\u5b9a\u9700\u8981\u683c\u5f0f\u5316\u7684SCD\u6587\u4ef6");
                return;
            }
            try {
                long t1 = new Date().getTime();
                validate.formatScd();
                System.out.println(new Date().getTime() - t1);
            }
            catch (FileNotFoundException e) {
                System.out.println("ValidOverWithError:" + e.getMessage());
            }
            catch (TransformerException e) {
                System.out.println("ValidOverWithError:" + e.getMessage());
            }
            catch (UnsupportedEncodingException e) {
                System.out.println("ValidOverWithError:" + e.getMessage());
            }
            return;
        }
        if (opttype.equals("1")) {
            if (args.length >= 2) {
                scdXml = args[1];
            }
            if (args.length >= 3) {
                xsdUrl = args[2];
            }
            if (args.length != 4) {
                System.out.println("ValidOverWithError:\u672a\u6307\u5b9a\u6821\u9a8c\u7ed3\u679c\u7684\u5b58\u653e\u8def\u5f84\u53ca\u6587\u4ef6");
                return;
            }
            savePath = args[3];
            if (xsdUrl.equals("")) {
                System.out.println("ValidOverWithError:\u672a\u6307\u5b9axsd\u6587\u4ef6");
                return;
            }
            if (scdXml.equals("")) {
                System.out.println("ValidOverWithError:\u672a\u6307\u5b9a\u9700\u8981\u6821\u9a8c\u7684scd\u6587\u4ef6");
                return;
            }
            System.out.println("\u6821\u9a8c\u7684scd\u6587\u4ef6\uff1a" + scdXml);
            System.out.println("\u6821\u9a8c\u7684xsd\u6587\u4ef6\uff1a" + xsdUrl);
            System.out.println("\u6821\u9a8c\u7684\u7ed3\u679c\u6587\u4ef6\uff1a" + savePath);
        }
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            Schema schema = factory.newSchema(new File(xsdUrl));
            FileInputStream scdFs = new FileInputStream(scdXml);
            Validator validator = schema.newValidator();
            XMLErrorHandler errorHandler = new XMLErrorHandler();
            validator.setErrorHandler((ErrorHandler)errorHandler);
            StreamSource source = new StreamSource(new File(scdXml));
            try {
                try {
                    long t1 = new Date().getTime();
                    validator.validate(source);
                    if (errorHandler.getErrors().hasContent()) {
                        document = saxReader.read(new File(scdXml));
                        FileReader in = null;
                        LineNumberReader reader = null;
                        in = new FileReader(scdXml);
                        reader = new LineNumberReader(in);
                        OutputStreamWriter errorFile = new OutputStreamWriter((OutputStream)new FileOutputStream(savePath), "UTF-8");
                        List errorlist = errorHandler.getErrors().selectNodes("error");
                        int tl = 1;
                        String linetext = "";
                        int prevErrorLine = 0;
                        reader.readLine();
                        int i = 0;
                        while (i < errorlist.size()) {
                            String errorMsg = validate.getErrorMsg(xsdUrl, (Element)errorlist.get(i));
                            if (errorMsg != null) {
                                String lineno = errorMsg.split("\\|")[0];
                                int cl = Integer.parseInt(lineno);
                                if (cl != prevErrorLine) {
                                    prevErrorLine = cl;
                                    while ((linetext = reader.readLine()) != null) {
                                        if (++tl != cl) continue;
                                    }
                                }
                                byte[] bytes = linetext.getBytes(Charset.forName("UTF-8"));
                                String str = new String(bytes, StandardCharsets.UTF_8);
                                errorFile.write(String.valueOf(errorMsg) + "|" + str + "\n");
                            }
                            ++i;
                        }
                        errorFile.close();
                        reader.close();
                        in.close();
                    }
                    System.out.println(new Date().getTime() - t1);
                    System.out.println("ValidOverWithOK");
                }
                catch (SAXParseException ex) {
                    System.out.println("ValidOverWithError:" + String.valueOf(ex.getLineNumber()) + "," + ex.getMessage());
                    scdFs.close();
                }
                catch (Exception ex) {
                    System.out.println("ValidOverWithError:" + ex.getMessage());
                    scdFs.close();
                }
            }
            finally {
                scdFs.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("ValidOverWithError:" + e.getMessage());
        }
    }

    private static void compScd() {
    }

    private static void formatScd() throws FileNotFoundException, TransformerException, UnsupportedEncodingException {
        StreamSource xmlInput = new StreamSource(new FileReader(scdXml));
        String outputFilePath = String.valueOf(scdXml) + ".format";
        if (!savePath.equals("")) {
            outputFilePath = savePath;
        }
        System.out.println(outputFilePath);
        OutputStreamWriter outputFile = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFilePath), "UTF-8");
        StreamResult xmlOutput = new StreamResult(outputFile);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("indent-number", 4);
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "GB2312");
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(xmlInput, xmlOutput);
    }

    private static String getErrorMsg(String path, Element errorElement) throws Exception {
        String errorContent = errorElement.getText();
        String lineno = errorElement.attributeValue("line").toString();
        String errmsg = String.valueOf(lineno) + "|" + errorContent;
        return errmsg;
    }

    class ValidationErrorHandler
    extends DefaultHandler {
        private List<String> errors = new ArrayList<String>();

        ValidationErrorHandler() {
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.errors.add(String.format("Error: line %d, column %d: %s", e.getLineNumber(), e.getColumnNumber(), e.getMessage()));
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            this.errors.add(String.format("Warning: line %d, column %d: %s", e.getLineNumber(), e.getColumnNumber(), e.getMessage()));
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.errors.add(String.format("Fatal Error: line %d, column %d: %s", e.getLineNumber(), e.getColumnNumber(), e.getMessage()));
        }
    }
}

