/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data;

import de.schlichtherle.license.CipherParam;
import de.schlichtherle.license.DefaultCipherParam;
import de.schlichtherle.license.DefaultLicenseParam;
import de.schlichtherle.license.KeyStoreParam;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseManager;
import de.schlichtherle.license.LicenseParam;
import java.io.File;
import java.util.prefs.Preferences;
import org.springframework.data.DataHolder;
import org.springframework.data.domain.DataPara;
import org.springframework.data.domain.KeyPara;

public class DataVerify {
    public synchronized LicenseContent install(DataPara param) throws Exception {
        LicenseManager licenseManager = DataHolder.getInstance(this.initLicenseParam(param));
        licenseManager.uninstall();
        LicenseContent result = licenseManager.install(new File(param.getLicensePath()));
        return result;
    }

    public boolean verify() throws Exception {
        try {
            LicenseManager licenseManager = DataHolder.getInstance(null);
            licenseManager.verify();
            return true;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private LicenseParam initLicenseParam(DataPara param) {
        Preferences preferences = Preferences.userNodeForPackage(DataVerify.class);
        DefaultCipherParam cipherParam = new DefaultCipherParam(param.getStorePass());
        KeyPara publicStoreParam = new KeyPara(DataVerify.class, param.getPublicKeysStorePath(), param.getPublicAlias(), param.getStorePass(), null);
        return new DefaultLicenseParam(param.getSubject(), preferences, (KeyStoreParam)publicStoreParam, (CipherParam)cipherParam);
    }
}

