package com.arcsoft.face;

/**
 * 人脸属性信息类
 */
public class FaceAttributeInfo {


    /**
     * 戴眼镜状态, 0 未戴眼镜；1 戴眼镜；2 墨镜
     */
    int wearGlasses;

    /**
     * 左眼状态, 0 闭眼；1 睁眼
     */
    int leftEyeOpen;

    /**
     * 右眼状态, 0 闭眼；1 睁眼
     */
    int rightEyeOpen;

    /**
     * 张嘴状态, 0 张嘴；1 合嘴
     */
    int mouthClose;


    /**
     *  获取戴眼镜状态, 0 未戴眼镜；1 戴眼镜；2 墨镜
     * @return  0 未戴眼镜；1 戴眼镜；2 墨镜
     */
    public int getWearGlasses() {
        return wearGlasses;
    }

    /**
     * 设置戴眼镜状态, 0 未戴眼镜；1 戴眼镜；2 墨镜
     * @param wearGlasses 0 未戴眼镜；1 戴眼镜；2 墨镜
     * @return 0 未戴眼镜；1 戴眼镜；2 墨镜
     */
    public FaceAttributeInfo setWearGlasses(int wearGlasses) {
        this.wearGlasses = wearGlasses;
        return this;
    }

    /**
     * 获取左眼状态 0 闭眼；1 睁眼
     * @return 0 闭眼；1 睁眼
     */
    public int getLeftEyeOpen() {
        return leftEyeOpen;
    }

    /**
     * 设置左眼状态 0 闭眼；1 睁眼
     * @param leftEyeOpen 0 闭眼；1 睁眼
     * @return 0 闭眼；1 睁眼
     */
    public FaceAttributeInfo setLeftEyeOpen(int leftEyeOpen) {
        this.leftEyeOpen = leftEyeOpen;
        return this;
    }

    /**
     * 获取右眼状态 0 闭眼；1 睁眼
     * @return 0 闭眼；1 睁眼
     */
    public int getRightEyeOpen() {
        return rightEyeOpen;
    }

    /**
     * 设置右眼状态 0 闭眼；1 睁眼
     * @param rightEyeOpen 0 闭眼；1 睁眼
     * @return 0 闭眼；1 睁眼
     */
    public FaceAttributeInfo setRightEyeOpen(int rightEyeOpen) {
        this.rightEyeOpen = rightEyeOpen;
        return this;
    }

    /**
     * 获取张嘴状态 0 张嘴；1 合嘴
     * @return 0 张嘴；1 合嘴
     */
    public int getMouthClose() {
        return mouthClose;
    }

    /**
     * 设置张嘴状态 0 张嘴；1 合嘴
     * @param mouthClose 0 张嘴；1 合嘴
     * @return 0 张嘴；1 合嘴
     */
    public FaceAttributeInfo setMouthClose(int mouthClose) {
        this.mouthClose = mouthClose;
        return this;
    }
}
