/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.conf;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Model;

public abstract class Infos {
    public Model getServerInfos() {
        Model result = new Model();
        try {
            result.setIpAddress(this.getIpAddress());
            result.setMacAddress(this.getMacAddress());
            result.setCpuSerial(this.getCpuSerial());
            result.setMainBoardSerial(this.getMainBoardSerial());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected List<String> getIpAddress() throws Exception {
        List result = null;
        List<InetAddress> inetAddresses = this.getLocalAllInetAddress();
        if (inetAddresses != null && inetAddresses.size() > 0) {
            result = inetAddresses.stream().map(InetAddress::getHostAddress).distinct().map(String::toLowerCase).collect(Collectors.toList());
        }
        return result;
    }

    protected List<String> getMacAddress() throws Exception {
        List result = null;
        List<InetAddress> inetAddresses = this.getLocalAllInetAddress();
        if (inetAddresses != null && inetAddresses.size() > 0) {
            result = inetAddresses.stream().map(this::getMacByInetAddress).distinct().collect(Collectors.toList());
        }
        return result;
    }

    protected abstract String getCpuSerial() throws Exception;

    protected abstract String getMainBoardSerial() throws Exception;

    protected List<InetAddress> getLocalAllInetAddress() throws Exception {
        ArrayList<InetAddress> result = new ArrayList<InetAddress>(4);
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface ni = networkInterfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = ni.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress addr = inetAddresses.nextElement();
                if (addr.isLoopbackAddress() || addr.isLinkLocalAddress() || addr.isMulticastAddress()) continue;
                result.add(addr);
            }
        }
        return result;
    }

    protected String getMacByInetAddress(InetAddress inetAddr) {
        try {
            byte[] mac = NetworkInterface.getByInetAddress(inetAddr).getHardwareAddress();
            StringBuilder stringBuffer = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                String temp;
                if (i != 0) {
                    stringBuffer.append("-");
                }
                if ((temp = Integer.toHexString(mac[i] & 0xFF)).length() == 1) {
                    stringBuffer.append("0").append(temp);
                    continue;
                }
                stringBuffer.append(temp);
            }
            return stringBuffer.toString().toUpperCase();
        }
        catch (SocketException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected String execShell(String[] shell) throws Exception {
        String number = "";
        Process process = Runtime.getRuntime().exec(shell);
        process.getOutputStream().close();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line = reader.readLine().trim();
        if (StringUtils.isNotBlank((CharSequence)line)) {
            number = line;
        }
        reader.close();
        return number;
    }

    protected String execCommand(String cmd) throws Exception {
        String number = "";
        Process process = Runtime.getRuntime().exec(cmd);
        process.getOutputStream().close();
        try (Scanner scanner = new Scanner(process.getInputStream());){
            if (scanner.hasNext()) {
                scanner.next();
            }
            if (scanner.hasNext()) {
                number = scanner.next().trim();
            }
        }
        return number;
    }
}

