//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.arcsoft.face;


/**
 * 人脸信息类
 */
public class FaceInfo {
    /**
     * 人脸位置信息
     */
    Rect rect;
    /**
     * 人脸角度信息
     */
    int orient;
    /**
     * 人脸id
     */
    int faceId = -1;

    /**
     * 人脸数据
     */
    byte[] faceData;
    /**
     * 人脸数据的长度
     */
    public static final int FACE_DATA_SIZE = 5000;

    /**
     *人脸是否在边界内 0 人脸溢出；1 人脸在图像边界内
     */
    int isWithinBoundary;

    /**
     * 人脸额头区域
     */
    Rect foreheadRect;


    /**
     * 人脸属性信息
     */
    FaceAttributeInfo faceAttributeInfo;

    /**
     * 人脸3D角度
     */
    Face3DAngle face3DAngle;


    /**
     * 创建一个新的人脸信息对象
     */
    public FaceInfo() {
        rect = new Rect();
        orient = 0;
        this.faceData = new byte[FACE_DATA_SIZE];
    }

    /**
     * 获取人脸位置信息
     *
     * @return 人脸位置信息
     */
    public Rect getRect() {
        return this.rect;
    }

    /**
     * 获取人脸角度信息
     *
     * @return 人脸角度信息
     */
    public int getOrient() {
        return this.orient;
    }

    /**
     * 获取人脸ID
     * @return  人脸ID
     */
    public int getFaceId() {
        return faceId;
    }

    /**
     * 获取人脸信息
     *
     * @return 人脸信息
     */
    public byte[] getFaceData() {
        return this.faceData;
    }

    /**
     * 设置人脸位置信息
     *
     * @param rect 人脸位置信息
     */
    public void setRect(Rect rect) {
        this.rect = rect;
    }

    /**
     * 设置人脸角度信息
     *
     * @param orient 人脸角度信息
     */
    public void setOrient(int orient) {
        this.orient = orient;
    }

    /**
     * 设置人脸ID
     * @param faceId    人脸ID
     */
    public void setFaceId(int faceId) {
        this.faceId = faceId;
    }


    /**
     * 设置人脸信息
     *
     * @param faceData 人脸信息
     */
    public void setFaceData(byte[] faceData) {
        this.faceData = faceData;
    }

    /**
     * 获取人脸是否在边界内
     * @return 0 人脸溢出；1 人脸在图像边界内
     */
    public int getIsWithinBoundary() {
        return isWithinBoundary;
    }

    /**
     * 人脸是否在边界内 0 人脸溢出；1 人脸在图像边界内
     * @param isWithinBoundary  0 人脸溢出；1 人脸在图像边界内
     * @return 人脸信息
     */
    public FaceInfo setIsWithinBoundary(int isWithinBoundary) {
        this.isWithinBoundary = isWithinBoundary;
        return this;
    }

    /**
     * 获取人脸额头区域
     * @return 人脸额头区域
     */
    public Rect getForeheadRect() {
        return foreheadRect;
    }

    /**
     * 设置人脸额头区域
     * @param foreheadRect 人脸额头区域
     * @return 人脸额头区域
     */
    public FaceInfo setForeheadRect(Rect foreheadRect) {
        this.foreheadRect = foreheadRect;
        return this;
    }

    /**
     * 获取人脸属性信息
     * @return 人脸属性信息
     */
    public FaceAttributeInfo getFaceAttributeInfo() {
        return faceAttributeInfo;
    }

    /**
     * 设置人脸属性信息
     * @param faceAttributeInfo 人脸属性信息
     * @return 人脸属性信息
     */
    public FaceInfo setFaceAttributeInfo(FaceAttributeInfo faceAttributeInfo) {
        this.faceAttributeInfo = faceAttributeInfo;
        return this;
    }

    /**
     * 获取人脸3D角度
     * @return 人脸3D角度
     */
    public Face3DAngle getFace3DAngle() {
        return face3DAngle;
    }

    /**
     * 设置人脸3D角度
     * @param face3DAngle 人脸3D角度
     * @return 人脸3D角度
     */
    public FaceInfo setFace3DAngle(Face3DAngle face3DAngle) {
        this.face3DAngle = face3DAngle;
        return this;
    }
}
